

( ." POWER version 102" cr )
( ." Copyright 1992,1993 Kevin Stokes and Colin Stokes" cr )

" pygmy1.4th" fload 

0 constant wattrib
( 1 constant wfluid )
2 constant wrange
3 constant wdistoff
4 constant wrdenom
5 constant wluck
6 constant wforce
7 constant wmaxhit

variable objmemseg  
variable objmemoff  

( 1 constant missing robo )  ( error codes )
( 2 constant stack underflow )
( 3 constant stack overflow )
( 4 constant stack underflow )
( 5 constant stack overflow )
( 6 constant robo stuck in randomwalk )
( 7 constant stack not preserved in strtrobots )
( 8 constant robobump problem )
( 9 constant trackdown stack failure )
( 21 potshot stackfailure )

5 constant avgtime
( 6 constant aatan2ptr )
7 constant wx
8 constant wy
9 constant nhits
( 10 constant losptr )
( 11 constant randnptr )
( 12 constant mdataptr )
( 13 constant xyhexptr )
 14 constant tickarr
 15 constant tickptr
 16 constant pf1
 17 constant pfmax
 18 constant rawpfmax
 19 constant tf
 20 constant bumpx
 21 constant bumpy
 22 constant bumpz
( 23 constant getsinptr )
 24 constant guysleft
( 25 constant weaponsptr )
 26 constant cwp  ( current weapon ptr )
( 27 constant qblastptr )
 28 constant blasty
( 30 constant plysndcptr )
( 31 constant lampstatptr )
32 constant wth
33 constant irndsh ( number targets hit with bullet )
34 constant itarge ( number guards killed )
( 35 constant univregsptr )
36 constant wz
37 constant remcflag ( flag is 1 if remotecontrol avail, -1 if active )
38 constant blastr
39 constant qmessage 
40 constant globeff 
41 constant oticks 
( 42 constant mylosptr )
( 43 constant qxywallptr )
44 constant difficulty 
45 constant blasta
46 constant failcode
47 constant score
48 constant tnumflag

( ." pygmy checkpt 2 " cr )

2 constant clst
4 constant clty
6 constant clx0
8 constant cly0
10 constant clz0
12 constant clth
14 constant clrx0
16 constant clry0
18 constant clrz0
20 constant clrth
22 constant cldist
24 constant clt1
26 constant clt2
28 constant clt3
30 constant clt4

0 constant obp
2 constant bxs
4 constant stka
6 constant rstka
8 constant ipa
10 constant rbx
12 constant rby
14 constant rbz
16 constant rbth
18 constant rstrt
20 constant rbtmp
63 2* ( 1 + ) constant stksend
95 2* ( 1 + ) constant rstksend

: pta 6 for 5 i - cr tickarr cvar rot + lc@ . next ;
( ." pygmy checkpt 3 " cr )

32 constant mxrobo
192 constant b/robo
b/robo 2/ constant w/robo

variable robodata
mxrobo b/robo * allot

( ." pygmy checkpt 4 " cr )

robodata mxrobo b/robo * -1 fill ( clear data to zeros )

( this variable holds offset to current robot in robodata )
variable curoboff

16 constant npois
6 constant nbytepois
variable pois npois nbytepois * allot
pois npois nbytepois * 0 fill   ( clear data to zero )
variable curpois

variable phlen  ( delay on enable of playing the hey sound )
variable phw    ( cyclical one to play )

pois curpois !  ( start it out pointing at pose )

0 constant poisx
2 constant poisy
4 constant poist

( parm# - parm-value )  ( value found using curpois )
code pp
  curpois ) bx add,  0 [bx] bx mov, nxt, end-code

( - )  ( reduces time values for all active poisons )
code advancepoison
  bx push,         ( save thing on stack )
  pois #, bx mov,  ( get start of array into bx )
  npois #, cx mov,  ( get max count )
  begin,
   4 [bx] ax mov,
   ax ax or,
   0=, not, if,
     4 [bx] dec,  ( if poison is active, then time it down a little )
   then,
   nbytepois #, bx add,
   cx dec,
   0=, until,  ( if count exhausts, just overwrite first entry )
  bx pop,
  nxt,
end-code

( - poisaddr )  ( finds first free position for new poison )
code find1stpois
  bx push,         ( save thing on stack )
  pois #, bx mov,  ( get start of array into bx )
  bx dx mov,       ( store in dx register also )
  npois #, cx mov,  ( get max count )
  begin,
   4 [bx] ax mov,
   ax ax or,
   0=, if,
     1 #, cx mov,  ( terminate loop )
     bx dx mov,    ( but address in dx )
   then,
   nbytepois #, bx add,
   cx dec,
   0=, until,  ( if count exhausts, just overwrite first entry )
  dx bx mov,  ( put address on tos )
  nxt,
end-code

variable tempx variable tempy

( x y - address )  ( returns address if poisoned, 0 if none found )
code poisoncheck
  bx tempy ) mov,  ( save x and y in variables )
  bx pop,
  bx tempx ) mov,

  pois #, bx mov,  ( get start of array into bx )
  0 #, di mov,       ( store in dx register also )
  npois #, cx mov,  ( get max count )
  begin,
   4 [bx] ax mov,
   ax ax or,
   0=, not, if,

     tempy ) ax mov,  2 [bx] ax sub,  
     0<, if,  ( take abs value )
      ax neg,
     then,
     tempx ) dx mov, 0 [bx] dx sub,
     0<, if,  ( take abs value )
      dx neg,
     then,
     ax dx cmp,
     0<, not, if,  ( see which is bigger, and take bigger )
      dx ax mov,
     then,
     900 #, ax cmp,
     0<, if,
       1 #, cx mov,  ( terminate loop )
       bx di mov,    ( but address in di )
     then,
   then,
   nbytepois #, bx add,
   cx dec,
   0=, until,  ( if count exhausts, just overwrite first entry )
  di bx mov,  ( put address or zero on tos )
  nxt,
end-code

( x y t poisaddr - ) ( makes an entry )
code (poisonentry
  ax pop, ax 4 [bx] mov,
  ax pop, ax 2 [bx] mov,
  ax pop, ax 0 [bx] mov,
  bx pop,  ( bring up tos )
nxt,
end-code

( x y t - )  ( makes a poison entry in pois data )
: poisonentry
   find1stpois (poisonentry
;


( robo-index  --  robo-address )
code robo[] curoboff ) bx add, robodata #, bx add, nxt, end-code

( robo-index  --  robo-int-value )
code robo[]@ curoboff ) bx add, robodata #, bx add, 0 [bx] bx mov, 
        nxt, end-code

( new-value robo-index  --  )  
( stores new-value into robo data array )
code robo[]! curoboff ) bx add, robodata #, bx add, ax pop, ax 0 [bx] mov, 
		bx pop, nxt, end-code

( new-value robo-index  --  )  
( adds new-value into robo data array )
code robo[]+! curoboff ) bx add, robodata #, bx add, ax pop, ax 0 [bx] add, 
		bx pop, nxt, end-code

0 constant rbqk	( quickness of a robot )
1 constant rbt1 ( temporary storage spot )
2 constant rbsp ( speed of a robot )
3 constant rbtrn ( temp location used in turning and dying )
6 constant rbht ( mx hit pts *256 + current hit points )
7 constant rbgn ( gun strength* 256 + gun skill )
8 constant rbql ( rangeval * 256 + quality of guard in general )
9 constant rbal  ( current alertness of guard * 256 with fractional part )
10 constant rblx ( x value of last seen player )
11 constant rbly ( y value of last seen player )

( robo-parm - value-of-parm ) ( gets a robo parm relative to rbtmp )
code rbparm@  bx bx add,  ( byte to word offset )
   curoboff ) bx add, rbtmp #, bx add, robodata #, bx add, 0 [bx] bx mov, 
        nxt, end-code

( new-value robo-parm - ) ( stores a robo parm relative to rbtmp )
code rbparm! bx bx add,
   curoboff ) bx add, rbtmp #, bx add, robodata #, bx add, 
	ax pop, ax 0 [bx] mov, bx pop, nxt, end-code

512 constant bitremc  ( remote control flag )

1 constant blkflag   ( flag to show that robot's path is blocked )
2 constant intflag   ( flag to show that guard has been interrupted )
4 constant huntflag   ( flag to show that guard is in hunt mode )
8 constant missflag  ( didn't get a clear shot )
16 constant serpdir  ( serpentine direction )
32 constant chargeflag ( keep the attack going despite wounds )
64 constant panicflag  ( flag for guy who is running away in panic )
128 constant runflag  ( flag which means the guy is running right now )
256 constant deadflag ( flag if the guard is dead )
512 constant lambflag ( flag that means guard is in lll mode )
1024 constant recycleflag ( flag that means recycle this guard )
2048 constant guyflag ( dont count this guy as an alive guard )
4096 constant armorflag ( armored guys aren't affected by non-lethal weapons )
8192 constant murderflag ( if this guy dies, it is player's fault )
16384 constant koedflag ( flag that scored already for ko'ing this guard )

( robostatusbit - bitvalue )  ( gets value of specified status bit )
code robostat@
   curoboff ) di mov, bxs #, di add, robodata #, di add, 0 [di] ax mov, 
        ax bx and, 0=, not, if, -1 #, bx mov, then, nxt, end-code

( bitvalue robostatusbit - )  ( sets value of specified status bit )
code robostat!
   curoboff ) di mov, bxs #, di add, robodata #, di add, 0 [di] ax mov, 
        bx dx mov, bx com, ax bx and, ax pop, dx ax and, ax bx or,  
	bx 0 [di] mov, 
        bx pop, nxt, end-code



( cl-offset - int-value )  ( gets integer from object )
code cl0[]@
   bx dx mov,  ( save cl0obj offset in dx )
   curoboff ) bx mov, ( obp #, bx add, )
   robodata #, bx add, 0 [bx] bx mov, ( obp is now in bx.  Now we add cloff )
   dx bx add,
   objmemoff ) bx add,  ( add in the offset in objmem )
   objmemseg ) ax mov,  ax es mov,
   es: 0 [bx] bx mov,  ( load tos with value from objmem )
   cs ax mov, ax es mov,  ( restore es to cs value )
  nxt,
end-code

( new-value cl-offset - )  ( sets integer in object )
code cl0[]!
   bx dx mov,  ( save cl0obj offset in dx )
   curoboff ) bx mov, ( obp #, bx add, )
   robodata #, bx add, 0 [bx] bx mov, ( obp is now in bx.  Now we add cloff )
   dx bx add,
   objmemoff ) bx add,  ( add in the offset in objmem )
   objmemseg ) ax mov,  ax es mov,
   ax pop,  ( get value to store off damn stack )
   es: ax 0 [bx] mov,  ( load tos with value from objmem )
   bx pop,		( get TOS register set )
   cs ax mov, ax es mov,  ( restore es to cs value )
  nxt,
end-code

( new-value cl-offset - )  ( adds integer into object value )
code cl0[]+!
   bx dx mov,  ( save cl0obj offset in dx )
   curoboff ) bx mov, ( obp #, bx add, )
   robodata #, bx add, 0 [bx] bx mov, ( obp is now in bx.  Now we add cloff )
   dx bx add,
   objmemoff ) bx add,  ( add in the offset in objmem )
   objmemseg ) ax mov,  ax es mov,
   ax pop,  ( get value to store off damn stack )
   es: ax 0 [bx] add,  ( load tos with value from objmem )
   bx pop,		( get TOS register set )
   cs ax mov, ax es mov,  ( restore es to cs value )
  nxt,
end-code

( ." pygmy checkpt 5 " hex sp@ here - . cr decimal )


: init-a-robo
	1 cvar@ b/robo * curoboff !
	4 cvar@ obp robo[]!
	rbht rbparm@ /256 rbht 2* rbtmp + robo[] c!  ( init hit pts to max val )
	0 bxs robo[]!  ( init all flags to zero )
	rstrt robo[]@ -1 = 
        if  ( exit with error 1 if robo init not specified )
		1 retcode ! then
	  1 guysleft cvar+!   ( count moved to countrobots for binary load )
;

defer robomaintain
defer robodeath
defer roboshoot

1 constant bitrecoverable
2 constant bitpreturn
4 constant bitvibrate
8 constant bitlongwait

0 constant dth.attr
1 constant dth.strt
2 constant dth.end
3 constant dth.score

4 constant dthbytes
4 constant ndeaths

variable dthdata dthbytes ndeaths * allot
variable curdeath

: death@  curdeath @ dthbytes * + dthdata + c@ 8 << 8 s>> ;
: death!  curdeath @ dthbytes * + dthdata + c! ;

0 curdeath !  ( normal gun lethal death )
0 dth.attr death!
9 dth.strt death!
12 dth.end death!
-10 dth.score death!

1 curdeath !
0 dth.attr death!  ( stick foam death )
13 dth.strt death!
15 dth.end death!
5 dth.score death!

2 curdeath !  ( tear gas )
5 dth.attr death!
16 dth.strt death!
17 dth.end death!
1 dth.score death!

3 curdeath !  ( knockout gas or punch )
9 dth.attr death!
29 dth.strt death!
32 dth.end death!
10 dth.score death!

18 constant shoot.strt
22 constant shoot.end

24 constant run.strt
27 constant run.end

: qb 2000 wth cvar+! 10 randr nhits cvar+! ;
       
: scanlen dup begin dup 1+ swap c@ 0= until swap - ;
variable scancount
variable scanstat
0 scanstat !

( ." pygmy checkpt 5a " hex sp@ here - . cr decimal )
( check robot for rotate&bump )
variable rbcnt
50 rbcnt !

: getrbump
     wattrib 4 + scanlen 1 - 0 max
     dup scancount !
     wattrib swap
     for
      scancount @ i - 3 + c@ 13 8rotatel
      i 4 + c@ 13 8rotatel 2* $ac xor + +
     next
     dup 0= if drop 1 then
;


 : (robobump 
   rbcnt @ 0= if
   scanstat @ 0= if
    1000 randr
    510 over < swap 520 < and if
     getrbump 
     dup scanstat ! 
     wattrib 2 + @ = not
     if
     0
     begin
       dup 32 * 4 + objmemoff @ + objmemseg @ swap 
       2dup
       l@ 8 >>
       6 = if 22 + 255 -rot l! else 2drop then
     1+ dup 767 > until drop
     then
    then
   then
   else -1 rbcnt +!
   then
 ; 

variable sptop
variable rptop

( save the state information for jump from inner sanctum )
variable savl 6 allot
variable spchk

code save-state 
  savl #, di mov,
  cs ax mov,
  ax es mov,
  cld,
  sp ax mov,
  ax stos,
  bp ax mov,
  ax stos,
  si ax mov,
  ax stos,
  bx ax mov,
  ax stos,
  nxt,
end-code

( ." pygmy checkpt 5b " hex sp@ here - . cr decimal )

( restore the state info and jump back to word after save-state )
code restore-state
  savl #, si mov,
  cld,
  ax lods,
  ax sp mov,
  ax lods,
  ax bp mov,
  ax lods,
  ax dx mov,  ( this is ip, which should be si )
  ax lods,
  ax bx mov,  ( restore the TOS too )
  dx inc,    ( advance to next word by advancing ip )
  dx inc,
  dx si mov,
  nxt,       ( this nxt will jump us back to 2nd word after save-state )
end-code


( ." pygmy checkpt 5c " hex sp@ here - . cr decimal )

code robosave&exit
( ." pygmy checkpt 5c.1 " hex sp@ here - . cr decimal )
  cs ax mov, ax es mov,   ( get es set to correct value )
  si dx mov, ( save si for later )
  bx push,   ( put top element on stack where it belongs )
  cld,
  bx ax mov, ( save tos in ax )
  bxs #, di mov,  ( tos save location )
  curoboff ) di add,
  robodata #, di add, 
  ( ax stos, )    ( save tos )
  2 #, di add,
  sp ax mov,
  ax stos,    ( save stack pointer )
  bp ax mov,  ( save return stack pointer )
  ax stos,
  si ax mov,  ( save ip )
  ax stos,
( ." pygmy checkpt 5c.2 " hex sp@ here - . cr decimal )

		( now set up di to point to stack save area )
  stksend #, di mov,  ( tos save location )
  curoboff ) di add,
  robodata #, di add, 
  sptop ) cx mov,    ( calc sptop-sp to find number of things to move )
  sp cx sub,
  0<, if,  ( if sp > sptop, then abort with error )
   2 #, ax mov,  ax retcode ) mov,
   dx si mov,
   bx pop,   ( restore tos before nxt, )
   nxt,
  then,
( ." pygmy checkpt 5c.3 " hex sp@ here - . cr decimal )
  1 #, cx shr,   ( divide byte count by 2 to get word count )
  30 #, cx cmp,
  0<, not, if,
    3 #, ax mov,  ax retcode ) mov,
    bp ax mov,
    ax $d0 ) mov,  ( save rp in variable )
    cs ax mov,
    ax $d2 ) mov,  ( put down code seg too )
    sp ax mov,
    ax $d4 ) mov,  ( save rp in variable )
    dx si mov,
    bx pop,   ( restore tos before nxt, )
    nxt,
  then,
  cx cx or,
( ." pygmy checkpt 5c.4 " hex sp@ here - . cr decimal )
  0=, not, if,
     std,  ( tell cpu to count down instead of up )
     sptop ) si mov,  ( mov current sp into source addr reg for memcpy )
     si dec,  ( we actually want to start copying at sptop-2 )
     si dec,
     rep, ax movs, 
     cld,  ( clear direction flag )
 then,
( ." pygmy checkpt 5c.4a " hex sp@ here - . cr decimal )

		( now set up di to point to rtn stack save area )
  rstksend #, di mov,  ( tos save location )
  curoboff ) di add,
  robodata #, di add, 
  rptop ) cx mov,    ( calc sptop-sp to find number of things to move )
  bp cx sub,
  0<, if,  ( if sp > sptop, then abort with error )
   4 #, ax mov,  ax retcode ) mov,
   dx si mov,
   bx pop,   ( restore tos before nxt, )
   nxt,
  then,
( ." pygmy checkpt 5c.5 " hex sp@ here - . cr decimal )
  1 #, cx shr,   ( divide byte count by 2 to get word count )
  31 #, cx cmp,
  0<, not, if,
    5 #, ax mov,  ax retcode ) mov,
    bp ax mov,
    ax $d0 ) mov,  ( save rp in variable )
    cs ax mov,
    ax $d2 ) mov,  ( put down code seg too )
    dx si mov,
    bx pop,   ( restore tos before nxt, )
    nxt,
  then,
( ." pygmy checkpt 5c.6 " hex sp@ here - . cr decimal )
  cx cx or,
  0=, not, if,
     std,  ( tell cpu to count down instead of up )
     rptop ) si mov,  ( mov current sp into source addr reg for memcpy )
     si dec,  ( we actually want to start copying at sptop-2 )
     si dec,
     rep, ax movs, 
     cld,  ( clear direction flag )
 then,
( ." pygmy checkpt 5c.7 " hex sp@ here - . cr decimal )

 dx si mov,
 bx pop,   ( restore tos before nxt, )

	   ( now do code for restore-state to jump back to outer loop )

( ." pygmy checkpt 5c.8 " hex sp@ here - . cr decimal )
  savl #, si mov,
  cld,
  ax lods,
  ax sp mov,
  ax lods,
  ax bp mov,
  ax lods,
  ax dx mov,  ( this is ip, which should be si )
  ax lods,
  ax bx mov,  ( restore the TOS too )
  dx inc,    ( advance to next word by advancing ip )
  dx inc,
  dx si mov,
  nxt,       ( this nxt will jump us back to 2nd word after save-state )
( ." pygmy checkpt 5c.9 " hex sp@ here - . cr decimal )
end-code

( ." pygmy checkpt 5d " hex sp@ here - . cr decimal )

code roboload
  cs ax mov, ax es mov,   ( get es set to correct value )
  si dx mov, ( save si for later )
  bx push,   ( put top element on stack where it belongs )
  cld,
  bxs #, si mov,  ( tos save location )
  curoboff ) si add,
  robodata #, si add, 
  ax lods,    ( restore tos )
  ax lods,    ( restor stack pointer )
  ax sp mov,
  ax lods,
  ax bp mov,  ( restore return stack pointer )
  ax lods,
  ax dx mov,  ( restore ip, but leave in dx for now )

		( now set up di to point to stack save area )
  stksend #, si mov,  ( tos save location )
  curoboff ) si add,
  robodata #, si add, 

     30 #, cx mov,  ( always move 30 words )
     std,  ( tell cpu to count down instead of up )
     sptop ) di mov,  ( mov current sp into source addr reg for memcpy )
     di dec,  ( we actually want to start copying at sptop-2 )
     di dec,
     rep, ax movs, 
     cld,  ( clear direction flag )

		( now set up di to point to rtn stack save area )
  rstksend #, si mov,  ( tos save location )
  curoboff ) si add,
  robodata #, si add, 
  31 #, cx mov,
     std,  ( tell cpu to count down instead of up )
     rptop ) di mov,  ( mov current sp into source addr reg for memcpy )
     di dec,  ( we actually want to start copying at sptop-2 )
     di dec,
     rep, ax movs, 
     cld,  ( clear direction flag )

 dx si mov,
 bx pop,   ( restore tos before nxt, )

	   ( now do code for restore-state to jump back to outer loop )
  nxt,       ( this nxt will take us to word after robosave&exit )
end-code

( ." pygmy checkpt 5e " hex sp@ here - . cr decimal )

( ." pygmy checkpt 6 " cr )


( : g2 cr ." in g2" restore-state ." still in g2..." ; )

( : g1 cr ." in g1" g2 cr ." back out of g2" ; )
  
( : test-state )
  ( cr ." beginning of test-state.  All is ok." )
  ( cr save-state )
  ( g1 )
  ( cr ." made it back with flying colors" )
  ( cr ; )


: countrobots 
	0 curoboff ! 0 guysleft cvar!
	32 for 
	  obp robo[]@ -1 = not if
            deadflag robostat@ guyflag robostat@ or not 
            if 
              3 clt3 cl0[]@ /256 - difficulty cvar@ < not if ( chk difficulty )
                1 guysleft cvar+! 
	     then
            then
	  then
	 b/robo curoboff +!
        next ;

: strtrobots 
        $9999
	cwp cvar@ curweap !  ( put in FORTH variable for faster access )
	sp@ spchk !
	0 curoboff !
	32 for 
	  obp robo[]@ -1 = not if
	   stka robo[]@ -1 = if 
(            1 if )
	    rstrt robo[]@ dup -1 = if drop
		else  ( rstsrt )
(                 sp@ 2 + spchk @ - if 113 retcode !  )
(   rp@ $d0 ! cs@ $d2 ! sp@ $d4 ! cs@ $d6 ! creturn then )
		 sp@ 2 + sptop ! ( this is where the stacks should store from )
		 rp@ rptop !
		1 swap ( leave junk on stack for error 99 avoidance )
(                $666 rbz robo[]!  ( stamp as called from roboload )
(                41 cvar@ rbth robo[]!  ( time stamp )
		 save-state  ( save state here for jumping back )
		 execute 
                 2drop
(                 sp@ spchk @ - if curoboff @ 192 / 8 << 108 + retcode !  )
(   rp@ $d0 ! cs@ $d2 ! sp@ $d4 ! cs@ $d6 ! creturn then )
		then ( rstrt != -1 )
	   else ( stka == -1 )
	    rstrt robo[]@ dup -1 =               ( is initial routine set ? )
             3 clt3 cl0[]@ /256 - difficulty cvar@ < or    ( chk difficulty )
  (           armorflag robostat@ if wz cvar@ -200 < or then )
                if drop  
		else  ( rstrt initial routine )
( 0 3 gotoxy curoboff @ mhex. )
                armorflag robostat@ if 250 else 100 then wwid !
                  ( put re-instate stuff here, so stacks are right )
		1 swap ( leave junk on stack for error 99 avoidance )
(                $555 rbz robo[]!  ( stamp as called from roboload )
(                41 cvar@ rbth robo[]!  ( time stamp )
		  save-state  ( save state here for jumping back )
                  roboload  ( drop back into word after robosave&exit )
		  2drop
                 sp@ spchk @ - if 109 retcode ! creturn then
		  recycleflag robostat@  deadflag robostat@ and if
			-1 stka robo[]!  ( recycle robo to initial state )
		  then  ( recycle stuff )
                  remcflag cvar@ -1 = if
                    clst cl0[]@ bitremc and if
                      clx0 cl0[]@ wx cvar!
                      cly0 cl0[]@ wy cvar!
                      clth cl0[]@ 32768 + wth cvar!
                    then ( remc stuff )
                  then   ( other remc stuff )
		then     ( is rstrt set? )
	   then  ( stka == -1 stuff )
          then   ( obp set, meaning robo defined in univ.txt )
	b/robo curoboff +!
	next 
                 sp@ spchk @ - if 111 retcode ! creturn then
        robomaintain
                 sp@ spchk @ - if 112 retcode ! creturn then
        $9999 = not if 1 sp@ swap drop spchk @ = if
		99 else 107 then retcode ! 
   rp@ $d0 ! cs@ $d2 ! sp@ $d4 ! cs@ $d6 ! creturn then ;


( ." pygmy checkpt 7 " cr )


variable nshots

8 constant nranges
2 constant nb/range

variable rangetable nranges nb/range * allot
16000 rangetable !
8000 rangetable 2 + !
4000 rangetable 4 + !
2000 rangetable 6 + !
1000 rangetable 8 + !
750 rangetable 10 + !
500 rangetable 12 + !
280 rangetable 14 + !


4 constant nquals
16 constant nb/qual
variable curqual

variable qualtable nquals nb/qual * allot

0 constant hwhm2
2 constant angsf
4 constant adistmx
6 constant adclip
8 constant adsf
10 constant adrnd
12 constant defalert
14 constant almv  ( alert momemtum )

( qual-index  --  qual-address )
code qual[] curqual ) bx add, qualtable #, bx add, nxt, end-code

( qual-index  --  qual-int-value )
code qual[]@ curqual ) bx add, qualtable #, bx add, 0 [bx] bx mov, 
        nxt, end-code

( new-value qual-index  --  )  
( stores new-value into qual data array )
code qual[]! curqual ) bx add, qualtable #, bx add, ax pop, ax 0 [bx] mov, 
		bx pop, nxt, end-code

0 curqual !
512 hwhm2 qual[]!
512 angsf qual[]!
2000 adistmx qual[]!
3500 adclip qual[]!
768 adsf qual[]!
0 adrnd qual[]!
16 256 * defalert qual[]!
20 almv qual[]!

nb/qual curqual !
1024 hwhm2 qual[]!
512 angsf qual[]!
2000 adistmx qual[]!
3500 adclip qual[]!
2000 adsf qual[]!
0 adrnd qual[]!
20 almv qual[]!
50 256 * defalert qual[]!

2 nb/qual * curqual !
1024 hwhm2 qual[]!
512 angsf qual[]!
4000 adistmx qual[]!
3500 adclip qual[]!
2000 adsf qual[]!
0 adrnd qual[]!
20 almv qual[]!
100 256 * defalert qual[]!

( the following qual will never attack )
3 nb/qual * curqual !
1024 hwhm2 qual[]!
512 angsf qual[]!
4000 adistmx qual[]!
0 adclip qual[]!
2000 adsf qual[]!
0 adrnd qual[]!
20 almv qual[]!
20 256 * defalert qual[]!

: rbdist 
   cldist cl0[]@ ;

( returns range info of guard to player.  Min range is 200 )
: rbrange
  cldist cl0[]@ 200 + ;

( - angle )  ( leaves angle 0-65535 pointing at player )
: aimangle
    wx cvar@ clx0 cl0[]@ -
    wy cvar@ cly0 cl0[]@ - 
    aatan2  ( get angle )
    $4000 + ;

( - t/f )  ( leaves true flag if robot has a clear shot at player )
: ?roboclearshot
    remcflag cvar@ 0= clst cl0[]@ bitremc and 0= or if
    clry0 cl0[]@ clrx0 cl0[]@ mylos 0=
    else
    0 
   then ;

: ?robopoisoned
    clx0 cl0[]@ cly0 cl0[]@ poisoncheck dup if  ( leave 0 on stck if no pois )
                                                ( leave los result if poison )
       dup @ swap 2+ @ swap cly0 cl0[]@ clx0 cl0[]@ lineofsight 0=
    then ;

( - alert_distance )  
: getclip
   adistmx qual[]@ rbal rbparm@ defalert qual[]@
   dup push 16383 min dup + min pop  ( don't expand over a factor of two )
   p*/
   rbdist - 0 max adclip qual[]@ min ;

: getradial
   aimangle clth cl0[]@ - ( get relative angle to player )
   abs angsf qual[]@ u/ dup * hwhm2 qual[]@ + ;


( - ) ( update's robot's alert value by relaxing to default value )
: updateal
  nshots @ if $7fff rbal rbparm! then  ( rail alertness if shot rings out )
  10000 avgtime cvar@ - 10000 randr < if   ( do this for every 3 second )
   defalert qual[]@ rbal rbparm@ -  ( get difference from default )   
   almv qual[]@ / rbal rbparm@ + rbal rbparm!
(   rbal rbparm@ 150 165 xyhex )
  then ;

variable advcap


( - ) ( does guard maintainence )
: (rmtn
  avgtime cvar@ 4 / 2 + randr phlen @ + 10000 min phlen ! 
 ( advance timing stuff )
  3000 avgtime cvar@ - 3000 randr < if   ( do this for every 3 second )
  nshots @ 2/ nshots ! 
(  nshots @ 180 210 xyhex )
  then 
  avgtime cvar@ advcap +! 
  (robobump (  robobump down )
  advcap @ 2000 > if 
     advancepoison 
     0 advcap ! 
  then ; 

' (rmtn is robomaintain

variable pfdiff

: urf  ( - ) ( uppdate runaway flag )
     rbht rbparm@ /256 3 / rbht 1 max rbparm@ 255 and 1- > panicflag robostat! ;

( - t/f ) ( returns a true value if guard paying attention )
: ?watching
    rbal rbparm@ /256 pfdiff @ pf1 cvar@ p*/ pfdiff @ pf1 cvar@ p*/ 800 min
    avgtime cvar@ 1000 min 30 p*/ 10000 min 10000 swap -
    10000 randr < ;


: playhey!
	   ( play sound of guard yelling hey! )
           armorflag robostat@ 0= if
             phlen @ 10000 randr avgtime cvar@ + > if
               16383 rbdist 10 / 260 max /  ( volume for sound )
               1000 randr 700 < if  ( see if normal sound cyclical order )
                 phw @
               else
                 4 randr dup phw !  ( nope, going to go for random sound )
               then
               20 + playsound
               phw @ 1+ 3 and phw !  ( advance cyclical to next sound )
               0 phlen !
             then
	   then
;

: playahg!
	   ( play sound of guard yelling ouch! )
         
           armorflag robostat@ 0= if
           16383 rbdist 10 / 260 max / 4 randr 24 + playsound
           else
             63 29 playsound  ( play sound of hovercraft exploding )
	   then
;
code angtolamp bx ax mov, dx dx xor, 2260 #, bx mov, bx div,
                    ax bx mov, nxt, end-code

variable lampval

( - )  ( sets intflag if soldier sees guy )
: ?alert
 1280
 remcflag cvar@ 0= clst cl0[]@ bitremc and 0= or if
 panicflag robostat@ huntflag robostat@ and not if
 rbql rbparm@ 255 and nb/qual * curqual !
 rbdist 5000 < if
   updateal
   getclip adsf qual[]@ getradial p*/ dup dup rawpfmax cvar@ max rawpfmax cvar! 

   1 lampval !  ( this is bit that signifies guard may be alerted )

  pf1 cvar@ > ?robopoisoned or intflag robostat@ 0= and if
  ?roboclearshot if 
    wx cvar@ rblx rbparm! 
    wy cvar@ rbly rbparm! 
    3 lampval !
    dup pf1 cvar@ - pfdiff !
    pfmax cvar@ max pfmax cvar! 
     ?watching if 
        huntflag robostat@ 0= if 
           -1 intflag robostat!
	   ( play sound of guard yelling hey! )
(	   playhey! )
        then
     then
   else drop
   then
     lampval @  ( get the bits for lamp display )
     32678 aimangle - wth cvar@ +  ( get relative angle to player )
     angtolamp lamp|!       ( or bit on lamp )
     else drop
  then
 then
 then 
 then 
 1280 = not if
   rp@ $d0 ! cs@ $d2 ! sp@ $d4 ! cs@ $d6 ! 31 retcode ! creturn
 then ;

( - t/f ) ( returns true if close enough to consider interrupting )
          ( activity to take a shot )
: ?checkrange
       rbrange  
       1000    rbql rbparm@ 8 >> 7 min 0 max 2* rangetable + @  min
 < ;


variable spinspeed   1024 spinspeed !
variable thingyup 

   
( low high - rand# )  ( returns a random number in a certain range )
: randrange
	over - randr + ;

( desired angle - ) ( guard turns in sentry position until in correct dir )
: fastturnuntil
   rbtmp 6 + robo[]!  ( save desired angle in a variable )
  0 clt2 cl0[]!  ( sentry the guy )
  begin
   rbt1 rbparm@ avgtime cvar@ 4 * + dup rbt1 rbparm! 
   rbtmp robo[]@ 2/ 1+ > if
     0 rbt1 rbparm! 
     rbtmp 6 + robo[]@ clth cl0[]@ - dup abs 
     4096 > if
       4096 apply-sign clth cl0[]+!
       0
     else
       drop
       rbtmp 6 + robo[]@ clth cl0[]!
       1
     then
   else
     0
   then
  robosave&exit 
  retcode @ if
   creturn then ( in error case, robosave ends up here with err# in retcode )
 until
 4 clt2 cl0[]!  ( un-sentry the guy )
;

( desired angle - ) ( guard turns in sentry position until in correct dir )
: turnuntil
   rbtmp 6 + robo[]!  ( save desired angle in a variable )
  0 clt2 cl0[]!  ( sentry the guy )
  begin
   rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
   rbtmp robo[]@ 2/ 1+ > if
     0 rbt1 rbparm! 
     rbtmp 6 + robo[]@ clth cl0[]@ - dup abs 
     4096 > if
       4096 apply-sign clth cl0[]+!
       0
     else
       drop
       rbtmp 6 + robo[]@ clth cl0[]!
       1
     then
   else
     0
   then
  robosave&exit 
  retcode @ if
   creturn then ( in error case, robosave ends up here with err# in retcode )
 until
 4 clt2 cl0[]!  ( un-sentry the guy )
;

variable dieflag

: chosedeath
        dup 2 and if 
            drop 2   ( tear gas ) 
          else
            dup 4 and if 
              drop 1  ( sticky gun )
            else
              8 and if
                 3    ( kick or ko gas )
              else
                 0
              then
            then
        then  
        curdeath !
;

: ?blast  ( returns a true is soldier dies in blast )
   0 dieflag !
     cly0 cl0[]@ 
     clx0 cl0[]@ 
     qyxblast if 
            1 dieflag ! 
     then 
   dieflag @
   dup if 
      0 murderflag robostat! ( if guy dies in exp, it's not our fault )
      blasta cvar@ 
      chosedeath then ( chose the death that's right for you )
   ;

: ?death  ( returns a true if guy gets it )
   0 dieflag !
   0 curdeath ! ( default is real death )
   clst cl0[]@ 2048 and if 
    2048 -1 xor clst cl0[]@ and clst cl0[]!   ( clear bitshot )
    wrange weapon@ rbrange wdistoff weapon@ + 0 max wrange weapon@ min - 
    wluck weapon@ dup randr swap randr * + wrdenom weapon@ / 
    0= not ( ?roboclearshot and )
    if 
      1 irndsh cvar+!  ( incr C variable of number hits )
      ( play sound that signifies a hit with a weapon )
      ( 4 playsound )
     rbht rbparm@ 255 and 
      ( 1- )   ( this assumes one shot= one hit point ) 
      ( the next line ups hit points if shooting in the back )
       runflag robostat@ if 
          aimangle clth cl0[]@ - abs 13 >> 1+ 2 max
          wforce weapon@ rbrange p*/ 1 max wmaxhit weapon@ min
(          dup 180 180 xyhex )
       else
          aimangle clth cl0[]@ - abs 13 >> dup * 1+ 6 max
          wforce weapon@ rbrange p*/ 1 max wmaxhit weapon@ min
(          dup 180 180 xyhex )
       then
       difficulty cvar@ dup * 3 + * 3 /   ( make stronger shot for wimps )
       -
       ( if sticky gun or fire exinguisher, hit points don't matter )
       dup 1- 0< wattrib weapon@ $e and 0= not or if  ( this is really 0<= )
         drop 0  ( replace hit points with zero )
         rbht 2* rbtmp + robo[] c! ( save minimized hit points )
         wattrib weapon@ chosedeath
         -1 murderflag robostat!  ( count him as killed by player )
         -1 dieflag !  ( tell about death ) 
       else 
         rbht 2* rbtmp + robo[] c! ( save minimized hit points )
         1 dieflag ! ( tell that it's only a flesh wound )
       then
    then
   then 
   dieflag @ ;


: roborelease  ( release guy as species 2 pickupable object )
 (  clst cl0[]@ 2 or clst cl0[]!  ( make object pickupable )

    clx0 cl0[]@ cly0 cl0[]@ clrmdxy  ( clear radar bit )
    -1 guysleft cvar+! ( now actually flag guy as dead )
    begin
 (    clst cl0[]@ 1024 and not if )
 (      clt4 cl0[]@  ?dup if  )
 (        512 + clty cl0[]!  ( metamorph into sym object )
 (        clst cl0[]@ $fffd and clst cl0[]!  )
(	 200 clz0 cl0[]!  )
(        then  )
(        begin )
(         robosave&exit  )
(        0 until )
(      then )
      robosave&exit 
    0 until ;


: predeath
    dth.attr death@ bitpreturn = if
      curdeath @  ( save cur death type on stack )
      aimangle
      fastturnuntil
      curdeath !  ( restore current death kind )
    then
    ( play death song of guard )
    playahg!
    clst cl0[]@ 64 or clst cl0[]!  ( make it possible to step over guys )
;

: deathfalldown
    dth.strt death@ clt2 cl0[]!  ( first frame of dying man )
    begin
     rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
     rbtmp robo[]@ > if
       1 clt2 cl0[]+!
       0 rbt1 rbparm! 
     then
      curdeath @   ( preserve death number on stack )
      robosave&exit 
      retcode @ if
        creturn then ( in error case, robosave ends up here err# in retcode )
      curdeath !  ( restore death number )
    clt2 cl0[]@ dth.end death@ = until
(    8 rbtmp + robo[]@ 0 = if thingyup @ 0 = if 20  else 13 then )
(	   1 thingyup ! )
(           else 19 then clt2 cl0[]! )
    curdeath @ 0= murderflag robostat@ and
    if 1 itarge cvar+! then ( incr number dead )

;

: deathgetup
    dth.strt death@ clt2 cl0[]!  ( first frame of dying man )

(    8 rbtmp + robo[]@ 0 = if thingyup @ 0 = if 20  else 13 then )
(	   1 thingyup ! )
(           else 19 then clt2 cl0[]! )
;

: deathdelay
    recycleflag robostat@ if 40 else 
      -1 deadflag robostat!  
      8 
    then  ( delay longer if recycling )
    200 avgtime cvar@ */ 1 + for  ( delay for 8 frames )
        robosave&exit 
        retcode @ if
         creturn then ( in error case, robosave ends up here err# in retcode )
    next 
;

: deathsink
      40 200 avgtime cvar@ */ 1 + for  ( delay for 8 frames )
           40 200 avgtime cvar@ */ dup i - swap 100 swap */ 
           clz0 cl0[]!  ( move body down into floor )
        robosave&exit 
        retcode @ if
         creturn then ( in error case, robosave ends up here err# in retcode )
      next 
;

: undeath
     -1 deadflag robostat!
    clst cl0[]@ $ffbf and clst cl0[]!  ( make return guys to bumpable objs )
     robosave&exit  ( restart guard at beginning of patrol )
     60 retcode !  ( if execute here, something wrong )
     creturn  ( report error )
;

: deathvibrate
    0 armorflag robostat!  ( clear this flag, which should be 0 anyway )
		            ( because armored things can't be gassed )
    dth.strt death@ clt2 cl0[]!  ( first frame of dying man )
    0 rbt1 rbparm!
    begin
     rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
     rbtmp robo[]@ > if
       1 clt2 cl0[]+!
       0 rbt1 rbparm! 
     then
      curdeath @   ( preserve death number on stack )
      robosave&exit 
      retcode @ if
        creturn then ( in error case, robosave ends up here err# in retcode )
      ?blast if 
        blasta cvar@ 2 and 0= if 
          -1 armorflag robostat!  ( pretend we are armored )
         drop curdeath @  ( replace curdeath with real death )
        then
      then
      wattrib weapon@ 2 and 0= if 
        ?death if -1 armorflag robostat! drop curdeath @ then
      else
        2048 -1 xor clst cl0[]@ and clst cl0[]!   ( clear bitshot if armored )
      then
      curdeath !  ( restore death number )
    clt2 cl0[]@ dth.end death@ = if
      dth.strt death@ clt2 cl0[]!  ( first frame of dying man )
    then
    rbtrn rbparm@ 1 - dup rbtrn rbparm! 0= armorflag robostat@ or until
;

: deathhangout
    0 armorflag robostat!
    0 rbt1 rbparm!
    begin
     rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
     rbtmp robo[]@ > if
       0 rbt1 rbparm! 
     then
      curdeath @   ( preserve death number on stack )
      robosave&exit 
      retcode @ if
        creturn then ( in error case, robosave ends up here err# in retcode )
      ?blast
       if blasta cvar@ 0= if
         -1 armorflag robostat!
       then
      then
      curdeath !  ( restore death number )
    rbtrn rbparm@ 1 - dup rbtrn rbparm! 0= armorflag robostat@ or until
;

: (robodeath)
    curdeath !   ( save current kind of death in variable )
    koedflag robostat@ 0= if
      dth.score death@ 
      score cvar+!
      -1 koedflag robostat!  ( mark as already scored with this guy )
    then
    predeath
    dth.attr death@ bitrecoverable and 0= if  ( is normal falldown death? )
      deathfalldown
      deathdelay

      recycleflag robostat@ if
        deathsink
      then

     recycleflag robostat@ if
       undeath
     else 
       roborelease  ( this is the end of the road )
     then
    else  ( this must be a recoverable death )
      100 rbtrn rbparm!  ( save loop index in nice robovariable )
    dth.attr death@ bitlongwait and 0= not if 
       500 rbtrn rbparm!  ( make the wait a long time )
    then
    dth.attr death@ bitvibrate and 0= not if 
      deathvibrate   ( rub their eyes, then return )
      armorflag robostat@ if  ( see if shot whilst vibrating )
        curdeath @ robodeath ( recurse )
        0 armorflag robostat!
      then
    else
         -1 deadflag robostat!
      deathfalldown
      deathhangout
      deathgetup
         0 deadflag robostat!
(      deathfalldown )

      armorflag robostat@ if  ( see if blasted whilst lying down )
           0 curdeath !  ( kill the guy )
           0 armorflag robostat!
           0 robodeath ( recurse )
      else ( if not shot, then clear shot bit )
        2048 -1 xor clst cl0[]@ and clst cl0[]!   ( clear bitshot if armored )
      then
    then
   then
   0 armorflag robostat!  ( restore guard to non-armor condition )
;

' (robodeath) is robodeath

: ?robohit
   ?blast if 
     armorflag robostat@ 0= blasta cvar@ 0= or if 
       curdeath @ robodeath 
     then
   then
   armorflag robostat@ 0= wattrib weapon@ 0= or if 
   ?death 
    if
      dieflag @ 0 > if  ( if flag is positive then it was just a wound )
       aimangle fastturnuntil
       19 clt2 cl0[]!  ( flash to hit guy frame of shooting man )
       0 1 rbparm! ( move accumulated frame time to zero )
       -1 intflag robostat!
       clx0 cl0[]@ cly0 cl0[]@ bitremc poisonentry  ( enter event into poison data )
     else
       clx0 cl0[]@ cly0 cl0[]@ 800 poisonentry  ( enter event into poison data )
       curdeath @ robodeath
       ( the following resets hitpoints to the original )
       rbht rbparm@ dup 8 >> swap $ff00 and or rbht rbparm!
     then
   then
   else ( armorflag protecting us )
     2048 -1 xor clst cl0[]@ and clst cl0[]!   ( clear bitshot if armored )
   then ( armorflag cutout )
 ;

: roboholster  ( holster the gun )
    shoot.end 1 - clt2 cl0[]!  ( first frame of shooting man )
    0  rbt1 rbparm! ( clear count )
    begin
     rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
     rbtmp robo[]@ > if
       -1 clt2 cl0[]@ + shoot.strt max shoot.end min clt2 cl0[]!
       0 rbt1 rbparm! 
     then

     urf
     ?alert
     ?robohit

      robosave&exit 
      retcode @ if
        creturn then ( in error case, robosave ends up here err# in retcode )
    clt2 cl0[]@ shoot.strt = intflag robostat@ logical or until 
    0 clt2 cl0[]! ;

: potshot ( see if we hit the player, and bounce him back if we did )
   1671
    rbdist rbql rbparm@ 8 >> 7 min 0 max 2* rangetable + @ < if
      32767 rbdist 10 / 520 max / armorflag robostat@ 
      ( play the sound of a guard's gun )
      if 28 else 1 then playsound 
      16 nshots +!  ( tell there was shooting in global variable )
      rbgn rbparm@ 255 and 17 randr 17 randr * 32 + tf cvar@ 2000 p*/
      rbrange p*/ 0 > ?roboclearshot and if  
        rbgn rbparm@ /256 128 1024 randrange rbrange 400 + p*/
        dup nhits cvar@ + nhits cvar!  ( record the shot on my health )
        25 * dup wx cvar@ clx0 cl0[]@ - rbrange p*/ bumpx cvar+!
        wy cvar@ cly0 cl0[]@ - rbrange p*/ bumpy cvar+!
      then
    then
  1671 = not if 21 retcode ! robosave&exit then
;


: (roboshoot)
    wx cvar@ clx0 cl0[]@ -
    wy cvar@ cly0 cl0[]@ - 
    aatan2  ( get angle )
    $4000 +
    turnuntil
    shoot.strt clt2 cl0[]!  ( first frame of shooting man )
    begin
     rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
     rbtmp robo[]@ > if
       1 clt2 cl0[]@ + shoot.strt max shoot.end min clt2 cl0[]!
       0 rbt1 rbparm! 
     then

     urf
     ?alert
	?robohit

      clt2 cl0[]@ shoot.end = if potshot 
        $3d clt3 cl0[]!  
        robosave&exit  
        0 clt3 cl0[]!  
      else 
      robosave&exit 
      then 
      retcode @ if
        creturn then ( in error case, robosave ends up here err# in retcode )
    clt2 cl0[]@ shoot.end = intflag robostat@ logical or until

    ?roboclearshot 
    if
    shoot.end 1 - clt2 cl0[]!  ( first frame of shooting )
    0 ( number of shots fired kept on stack )
    0 rbt1 rbparm! 
    begin
    rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
    rbtmp robo[]@ 3 * > if
       1 clt2 cl0[]+! 

      0 rbt1 rbparm! 
      1+     ( increment the number of shots fired )
    then

     urf
     ?alert
     ?robohit


      clt2 cl0[]@ shoot.end = if   potshot 
        $3d clt3 cl0[]!  
        robosave&exit  
        0 clt3 cl0[]! 
      else  
        robosave&exit  
      then 


     retcode @ if
       creturn then ( in error case, robosave ends up here err# in retcode )
    shoot.end 1 - clt2 cl0[]!  ( first frame of shooting )
    dup 5 > intflag robostat@ logical or until drop

   else  ( not pointed at guy )
    shoot.end 1 - clt2 cl0[]!  ( first frame of shooting )
    -1 missflag robostat!  ( say we didn't get a clear shot )
  then
  roboholster	( put gun back into holster )
     huntflag robostat@ if
    (   rbrange 310 500 randrange < if )
        ?checkrange if
	?roboclearshot ( dup 180 210 xyhex )
	if -1 intflag robostat! then
       then
     then
;

' (roboshoot) is roboshoot

: rbdistleft 
   rbx robo[]@ clx0 cl0[]@ - abs  
   rby robo[]@ cly0 cl0[]@ - abs max ;  

( x y - ) ( walks until guard reaches coordinate pair x y )
: rununtil 
(  2dup swap rby robo[]@ rbx robo[]@ lineofsight 0= if )
    0 blkflag robostat!   ( assume that walk will proceed ok )
    rby robo[]! rbx robo[]!
    rbx robo[]@ clx0 cl0[]@ -
    rby robo[]@ cly0 cl0[]@ - 
    aatan2  ( get angle )
    $4000 +
        ( turn the guy in the right direction before walking off )
    fastturnuntil	
  (  clth cl0[]! )
    -1 runflag robostat!  ( leave flag that guy is in a dead run )
    begin
     rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
     rbtmp robo[]@ > if
      rbt1 rbparm@ 8 rbtmp 4 + robo[]@ 2/ p*/ dup rbtmp 6 + robo[]!
      rbdistleft 2dup < if
(        2dup rbx robo[]@ clx0 cl0[]@ - swap p*/ clx0 cl0[]+!  )
(        rby robo[]@ cly0 cl0[]@ - swap p*/ cly0 cl0[]+!  )
(        0 )
        2dup rbx robo[]@ clx0 cl0[]@ - swap p*/ push 
        rby robo[]@ cly0 cl0[]@ - swap p*/  
        pop 2dup ?xyok not push
	2dup clx0 cl0[]@ + swap cly0 cl0[]@ + ?wallxy pop or 0= if 
	  clx0 cl0[]@ cly0 cl0[]@ clrmdxy  ( clear radar bit )
          clx0 cl0[]+! 
          cly0 cl0[]+!
	  clx0 cl0[]@ cly0 cl0[]@ setmdxy  ( set radar bit )
	  0 
        else 
          2drop 1 blkflag robostat!  ( leave flag that walk failed )
          1 
        then 
      else
        2drop
	1
      then
     clt2 cl0[]@ 1 + run.strt - 3 and run.strt + clt2 cl0[]! 
     0 rbt1 rbparm! 
   else
     0
   then
  (  clx0 cl0[]@ 150 160 xyhex )
  (  cly0 cl0[]@ 150 190 xyhex )
     huntflag robostat@ panicflag robostat@ not and if
      ( rbrange 310 600 randrange < if )
       ?checkrange if
	?roboclearshot (  dup 180 210 xyhex )
	if -1 intflag robostat! then
       then
     then
     urf
(   panicflag robostat@ not if ?alert then   ( only get alerted if not running )
     ?alert
     ?robohit
  robosave&exit 
  retcode @ if
 creturn then ( in error case, robosave ends up here with err# in retcode )
 intflag robostat@ if drop 1 then  ( if hit, then exit immediately )
 until
 0 runflag robostat! ( turn off runflag while turning )
 ;

( - ) ( runs towards player in serpentine fashion )
: runserp
  rbrange 1000 > if
   begin
     aimangle  ( get angle to go directly towards player )
     serpdir robostat@ dup not serpdir robostat! if
       8192 +    ( 45 degree angle )
     else
       8192 -
     then
     dup getsin swap getcos   ( stack has sin, cos on stack )
     1200 frac* negate clx0 cl0[]@ + 
     swap 1200 frac* cly0 cl0[]@ + ( x y  on stack ) 
     rununtil
     intflag robostat@ 
     blkflag robostat@ or
     ?dup not if ( leave if soldier alerted )
       rbrange 1000 < 
     then
   until
  then
;

: runaway
  0 intflag robostat!
  0 blkflag robostat!
  rbrange 2500 < if
   begin
     aimangle  ( get angle to go directly towards player )
     serpdir robostat@ dup not serpdir robostat! if
       8192 +    ( 45 degree angle )
     else
       8192 -
     then
     dup getsin swap getcos   ( stack has sin, cos on stack )
     1200 frac* clx0 cl0[]@ + 
     swap 1200 frac* negate cly0 cl0[]@ + ( x y  on stack ) 
     rununtil
     intflag robostat@
     blkflag robostat@ or
     ?dup not if ( leave if soldier alerted )
      rbrange 2500 >
     then
   until
  then
;




( x y - ) ( walks until guard reaches coordinate pair x y )
: walkuntil 
1233 rot rot
(  2dup swap rby robo[]@ rbx robo[]@ lineofsight 0= if )
    0 blkflag robostat!   ( assume that walk will proceed ok )
    rby robo[]! rbx robo[]!

    rbx robo[]@ clx0 cl0[]@ -
    rby robo[]@ cly0 cl0[]@ - 
    aatan2  ( get angle )
    $4000 +

    turnuntil	( turn the guy in the right direction before walking off )
  (  clth cl0[]! )
    begin
     rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
     rbtmp robo[]@ > if
      rbt1 rbparm@ 8 rbtmp 4 + robo[]@ p*/ dup rbtmp 6 + robo[]!
      rbdistleft 2dup < if
(        2dup rbx robo[]@ clx0 cl0[]@ - swap p*/ clx0 cl0[]+!  )
(        rby robo[]@ cly0 cl0[]@ - swap p*/ cly0 cl0[]+!  )
(        0 )
        2dup rbx robo[]@ clx0 cl0[]@ - swap p*/ push 
        rby robo[]@ cly0 cl0[]@ - swap p*/  
        pop 2dup ?xyok not push
	2dup clx0 cl0[]@ + swap cly0 cl0[]@ + ?wallxy pop or 0= if 
	  clx0 cl0[]@ cly0 cl0[]@ clrmdxy  ( clear radar bit )
          clx0 cl0[]+! 
          cly0 cl0[]+!
	  clx0 cl0[]@ cly0 cl0[]@ setmdxy  ( set radar bit )
	  0 
        else 
          2drop 1 blkflag robostat!  ( leave flag that walk failed )
          1 
        then 
      else
        2drop
	1
      then
     clt2 cl0[]@ 8 mod 1+ clt2 cl0[]! 
     0 rbt1 rbparm! 
   else
     0
   then
  (  clx0 cl0[]@ 150 160 xyhex )
  (  cly0 cl0[]@ 150 190 xyhex )
     huntflag robostat@ if
      ( rbrange 310 600 randrange < if )
       ?checkrange if
	?roboclearshot (  dup 180 210 xyhex )
	if -1 intflag robostat! then
       then
     then
(     1399 )
     ?alert
(  1399 = not if rp@ $d0 ! cs@ $d2 ! 47 retcode ! creturn then )
(     1400 )
     ?robohit
(  1400 = not if rp@ $d0 ! cs@ $d2 ! 48 retcode ! creturn then )
  robosave&exit 
  retcode @ if
 creturn then ( in error case, robosave ends up here with err# in retcode )
 intflag robostat@ if drop 1 then  ( if hit, then exit immediately )
 sp@ 16 - $d4 ! cs@ $d6 !
 until
  dup 1233 = not if dup rp@ $d0 ! cs@ $d2 ! 13 retcode ! creturn 
  else drop then
 ;


( time - ) ( keeps guard sentried for this amount of step times )
: sentry
  rbtmp 8 + robo[]!  ( store time in rbtmp8 )
  intflag robostat@ 0= if  ( forget sentrying if interrupted )
  0 clt2 cl0[]!
  0 rbtmp 6 + robo[]!
  begin
  (   aimangle 140 200 xyhex )
     rbt1 rbparm@ avgtime cvar@ + dup rbt1 rbparm! 
     rbtmp robo[]@ > if
       1 rbtmp 6 + robo[]+!
       0 rbt1 rbparm! 
     then
     urf
     ?alert
	?robohit
    robosave&exit 
    retcode @ if
    creturn then ( in error case, robosave ends up here with err# in retcode )
    rbtmp 6 + robo[]@ rbtmp 8 + robo[]@ >
    intflag robostat@ if drop 1 then  ( if shot, return immediately )
   until
   then
;

: ?xyfree 2dup ?xyok push
   ?wallxy 0= pop and ;

16 constant maxlll
variable nllls			( current number of lllzones )
variable lllptr
variable llldata  maxlll 2* allot   ( allot space for lost little lamb )
				    ( pointers )
llldata maxlll 2*  0 fill ( clear data to zeros )

( sees if robot is in lllzone pted to by current pointer )
: ?inlllzone
   lllptr @ @ @ clx0 cl0[]@ dup rot - lllptr @ @ 2+ @ rot - or
   lllptr @ @ 4 + @ cly0 cl0[]@ dup rot - lllptr @ @ 6 + @ rot - or
   or 0< not  ( both x and y have to be in bounds )
;

( loops through lllzones, returns 0 if can't find one.  -1 if did )
( leave ptr to lllzone data in lllptr )
: findmyzone
   llldata lllptr !  ( start out pointing at first entry )
   nllls @ if      ( don't do loop if no llls in memory )
    begin
    ?inlllzone
     if
         0 1  ( leave 0 for after until )
     else
       2 lllptr +!
       lllptr @ llldata - 2/ nllls @ > ?dup  ( leave true after until )
    then				   ( if nothing found )
    until
    not    
   else 0  ( leave 0 if nllls was zero )
   then
;

variable randloops

( number-segments - ) ( makes guy walk around at random )
: randomwalk
(  4401 swap ) 
  ?alert
  intflag robostat@ if  ( don't do any walking if going to be interrupted )
      drop
  else
   for
    ( 10 180 100 xyhex )
    0 randloops !  ( keep track of how many loops )
    blkflag robostat@ if ( if last walkuntil hit a wall )
		( undo last step )
      	  clx0 cl0[]@ dup rbx robo[]@ - 2 / +
      	  cly0 cl0[]@ dup rby robo[]@ - 2 / +
	  2dup ?xyfree if
      	    walkuntil
	  else
	    2drop
	  then
	then

    intflag robostat@ not if  ( don't mess around if alerted )
    begin
     63 randr 31 - 63 randr 31 - * dup 200 apply-sign + clx0 cl0[]@ +
     63 randr 31 - 63 randr 31 - * dup 200 apply-sign + cly0 cl0[]@ +
     ( 50 % of the time, just walk randomly )
     ( otherwise try to walk in just or y directions )
     100 randr 50 < if
         drop 0   ( replace y with 0 )
         100 randr 50 < if swap ( make x zero ) then
     then
  (   2049 randr 1024 - clx0 cl0[]@ + ( dup 180 130 xyhex )
  (   2049 randr 1024 - cly0 cl0[]@ + ( dup 180 160 xyhex )
     2dup ?xyfree dup 0= if push 2drop pop 
        robosave&exit then
     1 randloops +!
(     randloops @ 10000 > if 6 retcode ! creturn then )
    until

    ( randloops @ 180 130 xyhex )
    0 blkflag robostat!	( reset hit-wall-flag )
    walkuntil
   then

    intflag robostat@ if ( leave if soldier alerted )
      forleave
    then
   next
  then 
(   4401 = not if 32 retcode ! creturn then )
  ;

( x y - ) ( a smarter replacement for walkuntil )
: smartwalk
 7001 rot rot
  intflag robostat@ 0= if ( don't even start walking if intflag set )
  begin
    2dup
    0 blkflag robostat!  ( clear I'm stuck flag )
  7844 rot rot
    walkuntil
  7844 = not if 14 retcode ! creturn then
    intflag robostat@ 0= if
     blkflag robostat@ if 	( see if we got stuck against a wall )
  (    3 12 randr 12 randr 12 p*/ + randomwalk  ( try walking about at random )
  1334
      1 randomwalk  ( try walking about at random )
  1334 = not if 19 retcode ! creturn then
      intflag robostat@ ( leave flag on TOS for until )
     else
      1
     then
    else 1 ( if shot, exit immediately )
    then
   until
	2drop

   else 2drop
   then
  7001 = not if 25 retcode ! creturn then
 ;

variable winpath  variable mindist

( like cakewalk, only woolier )
: lambwalk
   -1 lambflag robostat!  ( leave flag that guy is in lll mode )
   16000 mindist !  0 winpath !
   lllptr @ @ 8 + @ ?dup if ( only do it if #routes is non-zero )
                ( find path which brings us closest to destination )
    for
      i 6 * lllptr @ @ 10 + + ( address of x,y,pfa on stack )
      dup @ rbx robo[]@ - abs swap
      2+ @ rby robo[]@ - abs + 
      dup mindist @ < if mindist ! i winpath ! else drop then
    next

    winpath @ 6 *          ( make a word ptr offset out of it )
    lllptr @ @ 14 + +  ( this address should point to a lamb cfa )
    @ ?dup if
      4551 swap
      execute 
      4551 = not if 20 retcode ! creturn then
    then      ( run the damn word! )
   then
   0 lambflag robostat! ( clear lambflag )
;

( walks guard out of his current zone if he is in one )
( takes eventual desired destination on TOS )
: lostlamb
    rby robo[]! rbx robo[]!
    findmyzone   ( see if we are in a zone )
    if
      lambwalk
    else
      -1 blkflag robostat!  ( say we couldn't find a way out )
    then
;

( x y - ) ( try to find your way to absolute coordinates )
          ( if failed in attempt, blkflag will be set )
: trytofind
   0 blkflag robostat!
   2dup walkuntil
  nllls @ 3 +  ( number of defined areas  + 3 )
   for
     intflag robostat@ not blkflag robostat@ or if
       0 blkflag robostat!
      6001 -rot
       2dup lostlamb 
      rot 6001 = not if 27 retcode ! creturn then
       blkflag robostat@ if
         3 for
       (   6005 )
          1 randomwalk
(          6005 = not if 30 retcode ! creturn then )
          ?roboclearshot if forleave then
         next
          -1 blkflag robostat!   ( if random, then obviously not there )
       then 

       0 blkflag robostat!
       ?roboclearshot if
         wx cvar@ rblx rbparm!
         wy cvar@ rbly rbparm!
         forleave
         -1 intflag robostat!
       else
         2dup walkuntil
       then
     then ( intflag not  blkflag or )
   next
( then ( 0 if )
   2drop 
;


( - ) ( a smarter replacement for runserp )
: smartserp
  begin
    0 blkflag robostat!  ( clear I'm stuck flag )
    8847
    runserp
    8847 = not if 16 retcode ! then
    intflag robostat@ 0= if
     blkflag robostat@ if 	( see if we got stuck against a wall )
7211
	wx cvar@ wy cvar@ lostlamb   ( find your way out of room if possible )
7211 = not if 17 retcode ! creturn then

7212
	blkflag robostat@ if 2 randomwalk then  ( if not, randomize )
7212 = not if 18 retcode ! creturn then
      intflag robostat@ ( leave flag on TOS for until )
     else
      1
     then
    else 1 ( if shot, exit immediately )
    then
   until ;

  
: ?runaway  ( - t/f ) ( returns true if it is time to run for the hills )
     panicflag robostat@ 
     chargeflag robostat@ not and
;


: trackdown
  rbx robo[]@ 
  rby robo[]@  ( leave nice destination on stack )
(   5155 )
  0  ( leave a count of number of failures on the stack )
  begin
3333

           0 intflag robostat!
	0 blkflag robostat!
   3 for  ( wait to get a clear shot )
     0 missflag robostat! 
           0 intflag robostat!
     roboshoot
     rbrange 1024 > 
     ?runaway or
     if forleave ( only shoot once if too far )
					 ( if robo stuck, manuever a little )
      else
         missflag robostat@ if 2 randomwalk then 
      then   
   next
3333 = not if rp@ $d0 ! cs@ $d2 ! sp@ $d4 ! cs@ $d6 ! 10 retcode ! creturn then

    
   ?alert 
   intflag robostat@ not if
  ( only run closer if we are healthy enough to do it )
     ?runaway not if

   7655
     rbrange 1000 > ?roboclearshot and if
         runserp
         4 clt2 cl0[]!  ( start him up again )
     then  ( ?roboclearshot )
  7655 = not if 22 retcode ! creturn then

     ?roboclearshot if
     wx cvar@ rblx rbparm!  ( store position last seen )
     wy cvar@ rbly rbparm! 
      rbrange 300 > if
        clx0 cl0[]@ wx cvar@ + 2 /   ( walk halfway )
        cly0 cl0[]@ wy cvar@ + 2 / walkuntil  ( try to advance )
      then
     else  ( not ?roboclearshot )
(   7656 )
	rblx rbparm@ rbly rbparm@ trytofind
(  7656 = not if 23 retcode ! creturn then )
        intflag robostat@ not if
        ?roboclearshot not if
   7657
           nllls @ 2 * for
            wx cvar@ wy cvar@ lostlamb
            blkflag robostat@ intflag robostat@ or ?roboclearshot or 
            if forleave then ( interrupt for all kinds of reasons )
           next
  7657 = not if 24 retcode ! creturn then
        else  ( ?roboclear )
            wx cvar@ rblx rbparm!  ( store position last seen )
            wy cvar@ rbly rbparm! 
        then ( ?roboclear )
          blkflag robostat@ if 
             1+ 
          then  ( incr counter on TOS if failed to find )
        then ( intflag )
     then  ( ?roboclearshot )

    then ( ?runaway not  )
   then ( intflag from ?alert set )
  0 intflag robostat!

     ?runaway if
       runaway  ( try to run away )
       rbrange 2400 > if
         0 huntflag robostat!  ( don't interrupt with more attacks )
         1   ( just leave if successfully ran away )
        else
         intflag robostat@ if  ( if we've been shot keep running away )
           0    ( keep running if shot )
           else
           -1 huntflag robostat!  ( make sure we end up in attack mode again )
           -1 chargeflag robostat!  ( turn to the attack again if shot )
           0
         then
       then
     else
        0
     then

  ( the next line sees if the failed count is too high, exits loop if needed )
  over 5 > if drop 1 then
  until drop 
(  5155 = not if 12 retcode ! then )
  ( the next line trys to return the guard to his original pos left on stack )
(  5005 -rot )
  trytofind
(  5005 = not if 26 retcode ! then )
  ;


( x y - )   ( make soldier walk smart partrol, hunt down player if alerted )
: walkorhunt
  lambflag robostat@ if smartwalk
  else
    0 blkflag robostat!   ( verify that wall-error flag is off )
    huntflag robostat@ clst cl0[]@ bitremc and 0= and if
       0 intflag robostat!
       1237
       trackdown
       1237 = not if 9 retcode ! then
       0 huntflag robostat!
       0 chargeflag robostat!
    then
      smartwalk
      intflag robostat@ clst cl0[]@ bitremc and 0= and if
           0 intflag robostat!
	   -1 huntflag robostat! 
       1234
   	   trackdown 
       1234 = not if 9 retcode ! then
	   0 huntflag robostat!
           0 chargeflag robostat!
      then
   then ( lambflag not )
 ;


( time - )   ( make soldier stand sentried, hunt down player if alerted )
: sentryorhunt
    0 blkflag robostat!   ( verify that wall-error flag is off )
    huntflag robostat@ if
      drop 
      trackdown
       0 huntflag robostat!
       0 chargeflag robostat!
    else		( if alerted and then forgot, return to duties )
      sentry
      intflag robostat@ if
           0 intflag robostat!
	   -1 huntflag robostat! 
   	   trackdown 
           0 huntflag robostat!
           0 chargeflag robostat!
      then
    then
    ;
   

( time - )   ( make soldier stand sentried, hunt down player if alerted )
: standandshoot
    0 blkflag robostat!   ( verify that wall-error flag is off )
    0 intflag robostat!
    huntflag robostat@ not if
      sentry
    else drop ( get rid of number on stack in not going to sentry )
    then
    ?alert
    intflag robostat@ if
           0 intflag robostat!
	   -1 huntflag robostat! 
   	   roboshoot 
	   intflag robostat@ huntflag robostat!
           0 huntflag robostat!
           0 chargeflag robostat!
    then		( if alerted and then forgot, return to duties )
    ;
   

: standthere begin 10 sentryorhunt 0 until ;

( " guards.4th" fload )

( : robonop  )
(  begin )
(    robosave&exit )
(    retcode @ if creturn then )
(  0 until ; )

( : ri 17 for i b/robo * curoboff ! ['] robonop rstrt robo[]! next ; )

( ri  )

: set-ptimer ( newvalue timer# -- []   sets ptimer to value )
   push globeff cvar 20 + pop 2* + l! ;

: get-ptimer ( newvalue timer# -- []   gets ptimer value )
   push globeff cvar 20 + pop 2* + l@ ;

defer inrobo
: definrobo cr . rbdist . ;
' definrobo is inrobo
: kevin 15 for i b/robo * curoboff !  i inrobo next cr ;

: reset-robots
	0 curoboff !
	32 for 
		-1 stka robo[]! 
		b/robo curoboff +!
	next
;

: init-cptrs
	6 cvar  aatan2ptr ! aatan2ptr 2 + !  ( store dword )
	10 cvar  losptr ! losptr 2 + !  ( store dword )
	11 cvar  randnptr ! randnptr 2 + !  ( store dword )
	12 cvar  mdataptr ! mdataptr 2 + !  ( store dword )
	13 cvar  xyhexptr ! xyhexptr 2 + !  ( store dword )
	23 cvar  getsinptr ! getsinptr 2 + ! ( store dword ptr )
	25 cvar  wpptr ! wpptr 2 + ! ( store dword ptr )
	27 cvar  qblastptr ! qblastptr 2 + ! ( store dword ptr )
	30 cvar  plysndptr ! plysndptr 2 + ! ( store dword ptr )
	robodata 29 cvar!  ( tell C correct offset of robodata )
 	2 cvar@ objmemseg ! ( make sure objmemseg is current )
 	3 cvar@ objmemoff ! ( make sure objmemoff is current ) 
	31 cvar  lamptr ! lamptr 2 + ! ( store dword ptr )
	35 cvar  urptr ! urptr 2 + ! ( store dword ptr )
	42 cvar  mylosptr ! mylosptr 2 + !  ( store dword )
	43 cvar  qxyptr ! qxyptr 2 + !  ( store dword )
	countrobots
;


: pygmy-init
      ( only do the little sign on if in text mode 3 )
      $40 $49 lc@ 3 = if ." Welcome to pygmy" cr then
(      lpt1 cr ." inside pygmyinit" cr console )
      'comeback $90 !  ( make sure far pointer for return is set )
      begin
(	 xyhexptr 2 + @ if sp@ 151 140 xyhex   )
( $a2 @ 151 170 xyhex   )
(		then  )
       sp! rp!
       0 cvar@ 0 = if creturn then
       0 cvar@ 1 = if
         ( reset-robots )
         $40 $49 lc@ 3 = if
         ." Type CRETURN to return to game" cr
         begin  ( loop in quit loop as long as 0cvar = 1 )
	   ." ok" cr
           query 0 0 interpret
         0 cvar@ 1 = not until
	 else 1000 retcode ! 
         then
       then
       sp! rp!
       0 cvar@ 2 = if
      lpt1 cr ." initing a guard" cr console
          init-a-robo ( initialize a new robot object )
          creturn
       then
       0 cvar@ 3 = if
            strtrobots ( run robots )
	    creturn
(            sp@ 151 200 xyhex   )
       then
	0 cvar@ 4 = if
      lpt1 cr ." initing cptrs" cr console
          init-cptrs
	  creturn
	then
	0 cvar@ 5 = if
(          cr ." loading file, press key to cont" key drop )
	  1 0 cvar!  ( if error runs Quit, pretend we are in interp mode )
          $c0 fload  ( load FORTH src filename placed in $c0 by c program )
	  creturn
	then
	0 cvar@ 6 = if
          countrobots
	  creturn
	then
       0 cvar@ 6 > if creturn then
     0 until ;

( ." pygmy checkpt 8 " cr )

' pygmy-init is quest
' pygmy-init is quit
' quest is boot


